const express = require('express');
const axios = require('axios');
const cors = require('cors');

const app = express();
const PORT = 3001;
const API_KEY = 'cf6fb9475132ac72cef37103d5e14032'; // your key
const BASE_URL = 'http://api.aviationstack.com/v1/flights';

app.use(cors());

const fetchFlights = async (type) => {
  const url = `${BASE_URL}?access_key=${API_KEY}&${type}_iata=ORK&limit=15`;
  try {
    const { data } = await axios.get(url);
    const flights = data.data.map(flight => ({
      time: flight.departure?.scheduled || flight.arrival?.scheduled || 'N/A',
      flight: flight.flight?.iata || 'N/A',
      route: type === 'arr' ? flight.departure?.airport : flight.arrival?.airport,
      status: flight.flight_status || 'Unknown'
    }));
    return flights;
  } catch (err) {
    console.error(`❌ Error fetching ${type} data:`, err.message);
    return [];
  }
};

app.get('/api/arrivals', async (req, res) => {
  const arrivals = await fetchFlights('arr');
  res.json(arrivals);
});

app.get('/api/departures', async (req, res) => {
  const departures = await fetchFlights('dep');
  res.json(departures);
});

app.listen(PORT, () => {
  console.log(`🟢 AviationStack server running on http://localhost:${PORT}`);
});
